/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.auimlcvt.auiml.tags;

import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.auimlcvt.auiml.tags.AbstractAuimlTag;
import com.ibm.hwmca.fw.util.auimlcvt.auiml.tags.TagUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class CaptionTag
extends AbstractAuimlTag {
    private static final String TRACE_MASK = "CVTCAP";
    private static final String TRACE_MASKD = "XCVTCAPD";
    private static final String TRACE_MASKF = "XCVTCAPF";
    private static final String TRACE_MASKT = "XCVTCAPT";

    public CaptionTag(Element auimlElement, Document hmcmlDocument, String resource, String[] resources) {
        super(auimlElement, hmcmlDocument, resource, resources);
    }

    private String getParentName() {
        Element parent = (Element)this.getElement().getParentNode();
        return parent.getAttribute("NAME");
    }

    public void startHMCMLTag() {
        if (this.getElement().getElementsByTagName("META-TEXT").getLength() > 0) {
            this.addTextCaption();
        }
        if (this.getElement().getElementsByTagName("META-IMAGE").getLength() > 0) {
            this.addImageCaption();
        }
    }

    private void addImageCaption() {
        if (!this.isDirectChildOf("ACTION")) {
            NodeList imageNodes = this.getElement().getElementsByTagName("META-IMAGE");
            String src = ((Element)imageNodes.item(0)).getAttribute("NL:SRC");
            if ((src == null || src.trim().equals("")) && (src = ((Element)imageNodes.item(0)).getAttribute("SRC")) == null) {
                src = "";
            }
            try {
                src = src.substring(src.indexOf("//") + 2);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "unable to get a substring on the image caption src: " + src + "[" + e.getMessage() + "]");
            }
            Element image = this.hmcmlDocument.createElement("img");
            this.addHmcId(image, this.getParentName() + ".IMAGE");
            this.setHmcmlElement(image);
            Object fmtMessage = null;
            if (this.isDirectChildOf("DATA-GROUP")) {
                boolean ignoreImage = false;
                if (this.hmcmlDocument.getElementsByTagName("table").getLength() == 1) {
                    ignoreImage = true;
                } else if (this.hmcmlDocument.getElementsByTagNameNS("wcl", "WNotebookPage").getLength() > 0) {
                    Element dataGroup = (Element)this.getElement().getParentNode();
                    NodeList notebookPageList = this.hmcmlDocument.getElementsByTagNameNS("wcl", "WNotebookPage");
                    int notebookPageListLength = notebookPageList.getLength();
                    for (int i = 0; i < notebookPageListLength; ++i) {
                        if (!((Element)notebookPageList.item(i)).getAttributeNS("hmc", "id").equals(dataGroup.getAttribute("NAME"))) continue;
                        ignoreImage = true;
                    }
                }
                if (!ignoreImage) {
                    String container = this.getContainingElementName();
                    Element table = TagUtils.findTable(container, this.hmcmlDocument);
                    src = TagUtils.adjustImageSrcPath(this.fetchResourceValue(src));
                    image.setAttribute("src", src);
                    NodeList captions = table.getElementsByTagName("caption");
                    if (captions.getLength() > 0) {
                        Node firstCaption = captions.item(0);
                        firstCaption.insertBefore(image, firstCaption.getFirstChild());
                    } else {
                        Element caption = this.hmcmlDocument.createElement("caption");
                        caption.setAttribute("align", "left");
                        table.insertBefore(caption, table.getFirstChild());
                        caption.appendChild(image);
                    }
                }
            } else if (this.isDirectChildOf("GROUP") || this.isDirectChildOf("CHOICE")) {
                Element titledArea;
                if (this.hmcmlMountPoint != null && (titledArea = TagUtils.findParentWithTagName(this.hmcmlMountPoint, "titledArea")) != null) {
                    src = TagUtils.adjustImageSrcPath(this.fetchResourceValue(src));
                    image.setAttribute("src", src);
                    titledArea.getParentNode().insertBefore(image, titledArea);
                }
            } else {
                Element cell = this.findPosition();
                if (cell == null && (cell = this.hmcmlMountPoint) == null) {
                    return;
                }
                src = TagUtils.adjustImageSrcPath(this.fetchResourceValue(src));
                image.setAttribute("src", src);
                cell.insertBefore(image, cell.getFirstChild());
            }
        }
    }

    private void addTextCaption() {
        Element metaText = (Element)this.getElement().getElementsByTagName("META-TEXT").item(0);
        String rscKey = metaText.getAttribute("NL:SRC");
        if ((rscKey == null || rscKey.equals("")) && ((rscKey = metaText.getAttributeNS("NL", "SRC")) == null || rscKey.equals(""))) {
            return;
        }
        rscKey = rscKey.substring("resource://".length());
        Object fmtMessage = null;
        if (this.hmcmlMountPoint != null && this.hmcmlMountPoint.getTagName().equals("UserAction")) {
            this.hmcmlMountPoint.setAttribute("text", this.fetchResourceValue(rscKey));
        } else if (this.isDirectChildOf("ACTION") || this.isDirectChildOf("ACTION-GROUP")) {
            int i;
            int nlLength;
            NodeList nl;
            boolean found = false;
            if (this.hmcmlMountPoint != null && this.hmcmlMountPoint.getTagName().equals("WButton")) {
                this.hmcmlMountPoint.setAttribute("text", this.fetchResourceValue(rscKey));
                found = true;
            } else {
                Element button;
                int i2;
                NodeList nl2 = this.hmcmlDocument.getElementsByTagNameNS("wcl", "WButton");
                int nlLength2 = nl2.getLength();
                for (i2 = 0; i2 < nlLength2; ++i2) {
                    if (nl2.item(i2) == null || !(nl2.item(i2) instanceof Element) || !(button = (Element)nl2.item(i2)).getAttributeNS("hmc", "id").equals(this.getParentName())) continue;
                    found = true;
                    i2 = nl2.getLength();
                    button.setAttribute("text", this.fetchResourceValue(rscKey));
                }
                if (!found) {
                    nl2 = this.hmcmlDocument.getElementsByTagNameNS("hmc", "HelpButton");
                    nlLength2 = nl2.getLength();
                    for (i2 = 0; i2 < nlLength2; ++i2) {
                        if (nl2.item(i2) == null || !(nl2.item(i2) instanceof Element) || !(button = (Element)nl2.item(i2)).getAttribute("id").equals(this.getParentName())) continue;
                        found = true;
                        i2 = nl2.getLength();
                        button.setAttributeNS("wcl", "text", this.fetchResourceValue(rscKey));
                    }
                }
            }
            Element auimlMenuItem = (Element)this.getElement().getParentNode();
            Element auimlMenu = (Element)auimlMenuItem.getParentNode();
            if (auimlMenu != null) {
                while (auimlMenu.getParentNode() != null && auimlMenu.getParentNode() instanceof Element && ((Element)auimlMenu.getParentNode()).getTagName().equals("ACTION-GROUP")) {
                    auimlMenu = (Element)auimlMenu.getParentNode();
                }
            }
            String menuHmcId = auimlMenu != null ? auimlMenu.getAttribute("NAME") + "." + auimlMenuItem.getAttribute("NAME") : auimlMenuItem.getAttribute("NAME");
            if (!found && this.hmcmlMountPoint != null && (this.hmcmlMountPoint.getTagName().equals("MenuItem") || this.hmcmlMountPoint.getTagName().equals("Menu"))) {
                this.hmcmlMountPoint.setAttribute("text", this.fetchResourceValue(rscKey));
                found = true;
            }
            if (!found) {
                nl = this.hmcmlDocument.getElementsByTagNameNS("hmc", "MenuItem");
                nlLength = nl.getLength();
                for (i = 0; i < nlLength; ++i) {
                    Element menuItem;
                    if (nl.item(i) == null || !(nl.item(i) instanceof Element) || !(menuItem = (Element)nl.item(i)).getAttribute("id").equals(menuHmcId)) continue;
                    found = true;
                    i = nlLength;
                    menuItem.setAttribute("text", this.fetchResourceValue(rscKey));
                }
            }
            if (!found) {
                nl = this.hmcmlDocument.getElementsByTagNameNS("hmc", "Menu");
                nlLength = nl.getLength();
                for (i = 0; i < nlLength; ++i) {
                    Element menu;
                    if (nl.item(i) == null || !(nl.item(i) instanceof Element) || !(menu = (Element)nl.item(i)).getAttribute("id").equals(auimlMenu.getAttribute("NAME"))) continue;
                    found = true;
                    i = nlLength;
                    menu.setAttribute("text", this.fetchResourceValue(rscKey));
                }
            }
        } else if (this.isDirectChildOf("DATA-GROUP")) {
            boolean takenCareOf = false;
            if (this.hmcmlDocument.getElementsByTagName("table").getLength() == 1) {
                NodeList headList = this.hmcmlDocument.getElementsByTagName("head");
                Element title = this.hmcmlDocument.createElement("title");
                Text titleText = this.hmcmlDocument.createTextNode(this.fetchResourceValue(rscKey));
                title.appendChild(titleText);
                headList.item(0).appendChild(title);
                takenCareOf = true;
            } else if (this.hmcmlDocument.getElementsByTagNameNS("wcl", "WNotebookPage").getLength() > 0) {
                Element dataGroup = (Element)this.getElement().getParentNode();
                NodeList notebookPageList = this.hmcmlDocument.getElementsByTagNameNS("wcl", "WNotebookPage");
                int notebookPageListLength = notebookPageList.getLength();
                for (int i = 0; i < notebookPageListLength; ++i) {
                    if (!((Element)notebookPageList.item(i)).getAttributeNS("hmc", "id").equals(dataGroup.getAttribute("NAME"))) continue;
                    ((Element)notebookPageList.item(i)).setAttribute("tabText", this.fetchResourceValue(rscKey));
                    i = notebookPageListLength;
                    takenCareOf = true;
                }
            }
            if (!takenCareOf) {
                String container = this.getContainingElementName();
                Element table = TagUtils.findTable(container, this.hmcmlDocument);
                Element caption = this.hmcmlDocument.createElement("caption");
                caption.setAttribute("align", "top");
                caption.setAttribute("style", "text-align:left;");
                rscKey = ((Element)this.getElement().getParentNode()).getAttribute("NAME") + ".TEXT";
                Text captionText = this.hmcmlDocument.createTextNode(this.fetchResourceValue(rscKey));
                table.insertBefore(caption, table.getFirstChild());
                caption.appendChild(captionText);
            }
        } else if (this.hmcmlMountPoint != null && this.hmcmlMountPoint.getNamespaceURI() != null && this.hmcmlMountPoint.getNamespaceURI().equals("acvt") && (this.hmcmlMountPoint.getTagName().equals("RadioButton") || this.hmcmlMountPoint.getTagName().equals("CheckBox"))) {
            Element mp = this.hmcmlMountPoint;
            mp.setAttribute("text", this.fetchResourceValue(rscKey));
        } else if (this.isDirectChildOf("GROUP") || this.isDirectChildOf("CHOICE")) {
            Element titledArea;
            Element mp = this.hmcmlMountPoint;
            if (mp != null && (titledArea = TagUtils.findParentWithTagName(mp, "titledArea")) != null) {
                titledArea.setAttribute("title", this.fetchResourceValue(rscKey));
            }
        } else if (this.isTableElement() && !this.isDirectChildOf("TABLE")) {
            Element mp = this.hmcmlMountPoint;
            mp.setAttribute("caption", this.fetchResourceValue(rscKey));
        } else {
            Element cell = this.findPosition();
            if (cell == null) {
                cell = this.hmcmlMountPoint;
                if (cell == null) {
                    return;
                }
                boolean done = false;
                if ((cell.getNamespaceURI() == null || cell.getNamespaceURI().equals("")) && !cell.getTagName().equals("label")) {
                    done = true;
                }
                while (!done) {
                    if (cell.getParentNode() instanceof Element) {
                        if ((cell = (Element)cell.getParentNode()).getNamespaceURI() != null && !cell.getNamespaceURI().equals("") || cell.getTagName().equals("label")) continue;
                        done = true;
                        continue;
                    }
                    return;
                }
            }
            Element floatingLabel = this.hmcmlDocument.createElementNS("hmc", "FloatingLabel");
            floatingLabel.setAttribute("for", this.getParentName());
            floatingLabel.setAttribute("id", this.getParentName() + ".CAPTION");
            floatingLabel.setAttribute("text", this.fetchResourceValue(rscKey));
            if (((Element)this.getElement().getParentNode()).getTagName().equals("BOOLEAN")) {
                cell.appendChild(floatingLabel);
            } else {
                cell.insertBefore(floatingLabel, cell.getFirstChild());
            }
            this.setHmcmlElement(floatingLabel);
        }
    }
}

